/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Text;

namespace Pilot.Xps.Entities
{
    [Serializable]
    public class XpsDigitalSignature
    {
        public Guid Id { get; set; }
        public string Signer { get; set; }
        public string RequestedSigner { get; set; }
        public DateTime SignDate { get; set; }
        public bool IsCertificateValid { get; set; }
        public bool IsSigned { get; set; }
        public bool IsValid { get; set; }
        public string Role { get; set; }
        public bool CanUserSign { get; set; }
        public bool IsAdditional { get; set; }
    }

    public static class XpsDigitalSignatureSerializer
    {
        private class DigitalSignatureBinder : SerializationBinder
        {
            public override Type BindToType(string assemblyName, string typeName)
            {
                return typeof(XpsDigitalSignature);
            }
        }

        public static byte[] Serialize(IList<XpsDigitalSignature> ds)
        {
            var jsonString = JsonConvert.SerializeObject(ds);
            var bytes = Encoding.UTF8.GetBytes(jsonString);
            return bytes;
        }

        public static IList<XpsDigitalSignature> Deserialize(byte[] buffer)
        {
            var bytesAsString = Encoding.UTF8.GetString(buffer);
            var ds = JsonConvert.DeserializeObject<IList<XpsDigitalSignature>>(bytesAsString);
            return ds;
        }
    }
}
