/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using PilotRocketChatGateway.Authentication;

namespace PilotRocketChatGateway.PilotServer
{
    public static class HttpContextExtentions
    {
        public static string GetTokenActor(this HttpContext httpContext, IAuthHelper authHelper)
        {
            httpContext.Request.Headers.TryGetValue(AuthHelper.AUTH_HEADER_NAME, out var tokenSource);
            if (string.IsNullOrEmpty(tokenSource))
                return null;

            return authHelper.GetTokenActor(tokenSource);
        }
    }
}
