/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Reactive.Linq;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.SDK;

namespace PilotShare.Client
{
    public interface ISettingsService
    {
        Task<string> LoadBaseUrl();
        Task<string> LoadLinkUrl(Guid linkId);
    }

    [Export(typeof(ISettingsService))]
    public class SettingsService : ISettingsService
    {
        private string _baseUrl;
        private readonly IPersonalSettings _settings;

        [ImportingConstructor]
        public SettingsService(IPersonalSettings settings)
        {
            _settings = settings;
        }

        public Task<string> LoadBaseUrl()
        {
            if (_baseUrl != null)
                return Task.FromResult(_baseUrl);

            var tcs = new TaskCompletionSource<string>();
            _settings
                .SubscribeSetting(Const.SERVER_ADDRESS_FEATURE_KEY)
                .FirstAsync()
                .Subscribe(pair =>
                {
                    _baseUrl = pair.Value;
                    tcs.SetResult(_baseUrl);
                });

            return tcs.Task;
        }

        public async Task<string> LoadLinkUrl(Guid linkId)
        {
            var baseUrl = await LoadBaseUrl();
            baseUrl = baseUrl.TrimEnd('/');
            return $"{baseUrl}/files/{linkId}";
        }
    }
}
