/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using PilotShare.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace PilotShare.Server.Models
{
    public static class LinkDefinitionExtensions
    {
        public static string FileSize(this LinkDefinition linkDefinition)
        {
            return FileSizeToString(GetTotalSize(new[] { linkDefinition.Item }));
        }

        private static long GetTotalSize(IEnumerable<Item> items)
        {
            long total = 0;
            foreach (var item in items)
            {
                total += !string.IsNullOrEmpty(item.FileId) ? item.FileSize : 0;
                total += GetTotalSize(item.Children);
            }
            return total;
        }

        private static string FileSizeToString(long bytes)
        {
            if (bytes < 1024)
                return bytes.ToString("n0") + " Б";

            var kb = bytes / 1024;
            if (kb < 1024)
                return kb.ToString("n1") + " КБ";

            var mb = kb / 1024;
            if (mb < 1024)
                return mb.ToString("n1") + " МБ";

            var gb = mb / 1024;
            return gb.ToString("n1") + " ГБ";
        }
    }
}
