/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;

namespace PilotShare.Server.Models
{
    public class State
    {
        public static readonly State Unknown = new State();
        public static readonly State UnknownError = new State { ErrorMessage = "Unknown error" };

        public Guid Id { get; set; }
        public string FileName { get; set; }
        public string FileSize { get; set; }
        public string SharedBy { get; set; }
        public bool NeedPassword { get; set; }
        public int? Progress { get; set; }
        public string FileUrl { get; set; }
        public string ErrorMessage { get; set; }

        public State Clone()
        {
            return new State
            {
                FileName = FileName,
                FileSize = FileSize,
                SharedBy = SharedBy,
                NeedPassword = NeedPassword,
                Progress = Progress,
                FileUrl = FileUrl,
                ErrorMessage = ErrorMessage,
                Id = Id
            };
        }
    }
}