import { Component, Input, OnInit } from '@angular/core';
import { IRelation } from "@pilotdev/pilot-web-sdk";
import {
  MatCell,
  MatCellDef,
  MatColumnDef,
  MatHeaderCell, MatHeaderCellDef,
  MatHeaderRow,
  MatHeaderRowDef, MatRow, MatRowDef, MatTable
} from "@angular/material/table";
import { MatButton } from "@angular/material/button";
import { DatePipe } from "@angular/common";

@Component({
  selector: 'app-relations',
  standalone: true,
  imports: [
    MatCell,
    MatCellDef,
    MatColumnDef,
    MatHeaderCell,
    MatHeaderRow,
    MatHeaderRowDef,
    MatRow,
    MatRowDef,
    MatTable,
    MatHeaderCellDef,
    MatButton,
    DatePipe
  ],
  templateUrl: './relations.component.html',
  styleUrl: './relations.component.scss'
})
export class RelationsComponent {
  displayedColumns: string[] = ['id', 'name', 'targetId', 'type', 'versionId', 'showInfo'];

  @Input() relations: IRelation[] = [];

  public showInfo(relation: IRelation) {
    console.log(relation);
  }
}
