const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
module.exports = {
output: {
  publicPath: 'auto',
  uniqueName: 'object_view',
  scriptType: 'text/javascript',
},
optimization: {
  // fix a temporary bug
  runtimeChunk: false
},
plugins: [
  new ModuleFederationPlugin({
    name: 'object_view',
    library: { type: 'var', name: 'object_view' },
    filename: '[name].js',
    exposes: [
      {
        'IMenu<ObjectsViewContext>':
          './src/app/extension/object-view.ts',
      },
      {
        'IOpenspaceView<DialogContext>':
          './src/app/extension/object-view.ts',
      },
    ],
    shared: {
      '@angular/core': {
        singleton: true,
      },
      '@angular/common': {
        singleton: true,
      },
      '@angular/material': {
        singleton: true,
      },
      '@angular/forms': {
        singleton: true,
      },
      '@angular/router': {
        singleton: true,
      },
      'rxjs': {
        singleton: true,
      },
      '@pilotdev/pilot-web-sdk': {
        singleton: true,
      }
    }
  })
]
};
