const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
module.exports = {
output: {
  publicPath: 'auto',
  uniqueName: 'project_clone_wizard',
  scriptType: 'text/javascript',
},
optimization: {
  // fix a temporary bug
  runtimeChunk: false
},
plugins: [
  new ModuleFederationPlugin({
    name: 'project_clone_wizard',
    library: { type: 'var', name: 'project_clone_wizard' },
    filename: '[name].js',
    exposes: [
      {'IToolbar<ObjectsViewContext>': './src/app/model/toolbar.ts'},
      {'IMenu<ObjectsViewContext>': './src/app/model/menu.ts'},
    ],
    shared: {
      '@angular/core': {
        singleton: true,
      },
      '@angular/common': {
        singleton: true,
      },
      '@angular/forms': {
        singleton: true,
      },
      '@pilotdev/pilot-web-sdk': {
        singleton: true,
      }
    }
  })
]
};