import { HttpEvent, HttpEventType } from "@angular/common/http";
import { Guid, ICommandBuilderProvider, IProgressService, ProgressBarMode } from "@pilotdev/pilot-web-sdk";


export class FileCommand {

  public static readonly MENU_NAME = "fileCommand";
  private static readonly BACKEND_NAME = "FileCommandImplementation";

  constructor(private _commandBuilderProvider: ICommandBuilderProvider) {}
  
  public invoke(progressService: IProgressService): void {

    const builder = this._commandBuilderProvider.newCommandBuilder();
    const input = document.createElement('input');
    input.type = 'file';
    input.multiple = true;
    input.onchange = (event: Event) => {
      const element = event.target as HTMLInputElement;
      progressService.open(ProgressBarMode.Determinate);
      builder.fileCommand(FileCommand.BACKEND_NAME, Guid.newGuid())
             .files(Array.from(element.files!))
             .invoke<string[]>()
             .subscribe((event) => {
              if (event.type === HttpEventType.UploadProgress) {
                progressService.update(Math.round(100 * event.loaded / event.total!));
              }
          
              if (event.type === HttpEventType.Response) {
               progressService.update(100);
               progressService.close();
               this.uploaded(event.body!)
              }
             });
    }
    input.click();
  }

  private uploaded(responce: string[]) {
    alert(`responce: ${responce}`);
  }
} 