﻿using Pilot.WebServer.SDK;
using Pilot.WebServer.SDK.Search;
using System.ComponentModel.Composition;

namespace SearchSample;

[Export(typeof(ICommandHost))]
public partial class SearchSample : ICommandHost
{
    [ImportingConstructor]
    public SearchSample(ISearchService searchService, IRepositoryEvents events)
    {
        events.SubscribePeople().Subscribe(new PeopleEventsObserver(searchService));
    }
}