const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
const CopyPlugin = require("copy-webpack-plugin");

module.exports = {
  mode: 'development',
  entry: {main: './src/index.ts'},
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
    ]},
  resolve: {
    extensions: [".tsx", ".ts", ".jsx", ".js", ".json"],
  },
  output: {
    publicPath: 'auto',
    uniqueName: 'settings_support_sample',
    scriptType: 'text/javascript',
    filename: './[name].js',
    clean: true
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'settings_support_sample',
      library: { type: 'var', name: 'settings_support_sample' },
      filename: '[name].js',
      exposes: [{'IMenu<ObjectsViewContext>': './src/app/settingsSupportSample.ts'}],
      shared: {
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    }),

    new CopyPlugin({
      patterns: [
        { from: "./src/assets/extensions.config.json", to: "./extensions.config.json" }
      ],
    }),
  ]
};
