import { Component, Input, ViewEncapsulation } from '@angular/core';
import { IDataObject } from "@pilotdev/pilot-web-sdk";
import { MatTabsModule } from "@angular/material/tabs";
import { AttributesComponent } from "../tabs/attributes/attributes.component";
import { TypeComponent } from "../tabs/type/type.component";
import { CreatorComponent } from "../tabs/creator/creator.component";
import { StateInfoComponent } from "../tabs/state-info/state-info.component";
import { ChildrenComponent } from "../tabs/children/children.component";
import { AccessComponent } from "../tabs/access/access.component";
import { RelationsComponent } from "../tabs/relations/relations.component";
import { FilesComponent } from "../tabs/files/components/files-table/files.component";
import { SnapshotsComponent } from "../tabs/snapshots/snapshots.component";

@Component({
  selector: 'app-object-properties',
  standalone: true,
  imports: [
    MatTabsModule,
    AttributesComponent,
    TypeComponent,
    CreatorComponent,
    StateInfoComponent,
    ChildrenComponent,
    AccessComponent,
    RelationsComponent,
    FilesComponent,
    SnapshotsComponent
  ],
  animations: [],
  templateUrl: './object-properties.component.html',
  styleUrl: './object-properties.component.scss',
  encapsulation: ViewEncapsulation.None,
})
export class ObjectPropertiesComponent {

  @Input() object!: IDataObject;
}
