import { Component, Input, OnInit } from '@angular/core';
import { IDataObject } from "@pilotdev/pilot-web-sdk";
import { MatTableModule } from "@angular/material/table";

export interface AttributesData {
  name: string;
  value: unknown;
}

@Component({
  selector: 'app-attributes',
  standalone: true,
  imports: [
    MatTableModule
  ],
  templateUrl: './attributes.component.html',
  styleUrl: './attributes.component.scss'
})
export class AttributesComponent {
  private _object!: IDataObject;

  displayedColumns: string[] = ['name', 'value'];
  attributesDatasource: AttributesData[] = [];

  @Input() set object(dataObject: IDataObject) {
    this._object = dataObject;
    this.attributesDatasource = Object.entries(this.object.attributes).map(([name, value]) => ({ name, value }));
  }

  get object(): IDataObject {
    return this._object;
  }
}
