import { Component, Input, OnInit } from '@angular/core';
import { IDataObject, IFileSnapshot } from "@pilotdev/pilot-web-sdk";
import { MatListItem, MatNavList } from "@angular/material/list";
import { DatePipe, NgForOf, NgIf } from "@angular/common";
import { FilesComponent } from "../files/components/files-table/files.component";
import { MatTooltip } from "@angular/material/tooltip";

@Component({
  selector: 'app-snapshots',
  standalone: true,
  imports: [
    MatNavList,
    MatListItem,
    NgForOf,
    DatePipe,
    FilesComponent,
    NgIf,
    MatTooltip
  ],
  templateUrl: './snapshots.component.html',
  styleUrl: './snapshots.component.scss'
})
export class SnapshotsComponent implements OnInit {
  private _object!: IDataObject;
  selectedSnapshot!: IFileSnapshot;

  @Input() set object(dataObject: IDataObject) {
    this._object = dataObject;
  }
  get object(): IDataObject {
    return this._object;
  }

  ngOnInit(): void {
    if (this.object?.previousFileSnapshots?.length > 0) {
      this.selectedSnapshot = this.object.previousFileSnapshots[0]; // первая вкладка по умолчанию
    }
  }

  public selectTab(snapshot: IFileSnapshot): void {
    this.selectedSnapshot = snapshot;
  }

}
