/**
 * Copyright (c) 2024 ASCON-Design Systems LLC. All rights reserved.
 * This sample is licensed under the MIT License.
 */

import { Injectable } from '@angular/core';
import { ITabs, ITabsBuilder, BimElementPanelContext } from '@pilotdev/pilot-web-sdk';
import { ElementPanelTabId } from '../ids';

const elementIcon =
  'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBzdHJva2U9ImN1cnJlbnRDb2xvciIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiIGNsYXNzPSJsdWNpZGUgbHVjaWRlLWZpbGUtYXhpczNkLWljb24gbHVjaWRlLWZpbGUtYXhpcy0zZCI+PHBhdGggZD0iTTYgMjJhMiAyIDAgMCAxLTItMlY0YTIgMiAwIDAgMSAyLTJoOGEyLjQgMi40IDAgMCAxIDEuNzA0LjcwNmwzLjU4OCAzLjU4OEEyLjQgMi40IDAgMCAxIDIwIDh2MTJhMiAyIDAgMCAxLTIgMnoiLz48cGF0aCBkPSJNMTQgMnY1YTEgMSAwIDAgMCAxIDFoNSIvPjxwYXRoIGQ9Im04IDE4IDQtNCIvPjxwYXRoIGQ9Ik04IDEwdjhoOCIvPjwvc3ZnPg==';

@Injectable({providedIn: "root"})
export class BimElementPanelTabs implements ITabs<BimElementPanelContext> {
  build(builder: ITabsBuilder): void {
    builder
      .addItem(ElementPanelTabId, 1)
      .withTitle('Element Panel Sample')
      .withIcon('bim-document-sample-element-tab', elementIcon)
      .withViewId(ElementPanelTabId);
  }
}
