﻿using System.IO;
using System.Windows.Media.Imaging;

namespace Ascon.Pilot.Bim.SDK.ModelViewerSample
{
    public partial class PluginWindow : IUpdateListener
    {
        public PluginWindow()
        {
            InitializeComponent();
        }

        public void OnScreenshotUpdated(byte[] screenshot)
        {
            if (screenshot == null)
                return;

            var byteStream = new MemoryStream(screenshot);
            var image = new BitmapImage();
            image.BeginInit();
            image.StreamSource = byteStream;
            image.EndInit();
            ScreenshotImage.Source = image;
        }

        public void OnLogUpdated()
        {
            if (LogListView.Items.Count == 0)
                return;

            var lastItem = LogListView.Items[LogListView.Items.Count - 1];
            LogListView.SelectedItem = lastItem;
        }
    }
}