﻿using Ascon.Pilot.SDK;
using Ascon.Pilot.Bim.SDK;
using BcfApiService.Loaders;

namespace BcfApiService.Services
{
    public abstract class Service
    {
        protected readonly ObjectLoader _objectLoader;
        protected readonly PersonLoader _personLoader;
        protected readonly ObjectIdsByTypeIdLoader _objectIdsLoader;
        protected readonly IType _modelPartType;
        protected readonly IType _remarksFolderType;
        protected readonly IType _modelIssueType;
        protected readonly IType _modelRemarkType;

        protected Service(IObjectsRepository objectsRepository, ISearchService searchService)
        {
            _objectLoader = new ObjectLoader(objectsRepository);
            _personLoader = new PersonLoader(objectsRepository);
            _objectIdsLoader = new ObjectIdsByTypeIdLoader(searchService);
            _modelPartType = objectsRepository.GetType(TypeNames.ModelPart);
            _remarksFolderType = objectsRepository.GetType(TypeNames.RemarksFolder);
            _modelIssueType = objectsRepository.GetType("bim_modelIssue");
            _modelRemarkType = objectsRepository.GetType("bim_modelRemark");
        }
    }
}
