/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK.Controls.ObjectCardView;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace Ascon.Pilot.SDK.Controls
{
    public static class DictionaryStringFormatterEx
    {
        public static string Format(this string format, IReadOnlyDictionary<string, object> attributes, IFormatProvider defaulfFormatProvider, bool allowSkipMissingAttributes = true)
        {
            var result = new StringBuilder(format);
            var matches = Regex.Matches(format, @"\{(.+?)\}");
            var keys = (from Match matche in matches select matche.Groups[1].Value).ToList();

            foreach (var key in keys)
            {
                var k = key.Split(new[] { ':' }, 2);
                if (k.Length == 0)
                    continue;

                var arg = attributes.ContainsKey(k[0]) && attributes[k[0]] != null ? attributes[k[0]] : allowSkipMissingAttributes ? string.Empty : null;

                if (arg == null)
                    return string.Empty;

                var formattable = arg as IFormattable;
                string pattern = $"{{{key}}}";
                string defaultFormat = k.Length == 2 ? k[1] : string.Empty;

                if (formattable != null)
                    result.Replace(pattern, formattable.ToString(defaultFormat, defaulfFormatProvider));
                else
                    result.Replace(pattern, arg?.ToString());
            }

            return result.ToString().TrimEnd();
        }

    }
}