/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.IO;
using System.Linq;
using System.Text;
using Ascon.Pilot.SDK.Toolbar;
using Ascon.Pilot.Theme.Tools;
using Microsoft.Win32;

namespace Ascon.Pilot.SDK.ObjectDialogPreviewSample
{
    [Export(typeof(IToolbar<ObjectDialogPreviewContext>))]
    public class MainModule : IToolbar<ObjectDialogPreviewContext>
    {
        public void Build(IToolbarBuilder builder, ObjectDialogPreviewContext context)
        {
            // Replace standart button
            builder.ReplaceButtonItem("tbiOpenFile").WithHeader("Add file");
            // Add new button
            builder.AddButtonItem("tbiNewButton", 1).WithHeader("New button");
        }

        public void OnToolbarItemClick(string name, ObjectDialogPreviewContext context)
        {
            if (name == "tbiOpenFile")
            {
                StringBuilder filter = new StringBuilder();
                filter.AppendLine("Поддерживаемые типы (*.xps;*.dwfx;*.pdf;*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.bmp)|*.xps;*.dwfx;*.pdf;*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.bmp|");
                filter.AppendLine("Документы XPS (*.xps)|*.xps|");
                filter.AppendLine("Документы DWFx (*.dwfx)|*.dwfx|");
                filter.AppendLine("Документы PDF (*.pdf)|*.pdf|");
                filter.AppendLine("Картинки (*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.bmp)|*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.bmp");
                var title = "Открыть существующий документ";

                List<string> filePaths;
                if (ShowOpenFileDialog(title, filter.ToString(), false, null, out filePaths) == true)
                {
                    var path = filePaths[0];
                    context.PreviewModifier.SetFilePath(path);
                }
            }
        }

        private bool? ShowOpenFileDialog(string title, string filter, bool mutiselect, string initialDirectory, out List<string> filePaths)
        {
            var dialog = new OpenFileDialog
            {
                Multiselect = mutiselect,
                Title = title
            };

            if (filter != null)
                dialog.Filter = filter;

            if (initialDirectory != null && Directory.Exists(initialDirectory))
            {
                var fullPath = Path.GetFullPath(initialDirectory);
                dialog.InitialDirectory = fullPath;
            }

            try
            {
                bool? result = null;
                LayoutHelper.DoSuppressEvents(() =>
                {
                    result = dialog.ShowDialog(LayoutHelper.GetOwnerWindow());
                });
                return result;

            }
            finally
            {
                filePaths = dialog.FileNames.ToList();
            }
        }
    }
}
