/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using System.Windows;
using System.Windows.Documents;
using System.Windows.Input;

namespace Ascon.Pilot.SDK.SearchSample.SourceFileSearch
{
    /// <summary>
    /// Interaction logic for SearchResultsView.xaml
    /// </summary>
    public partial class SearchResultsView
    {
        public SearchResultsView()
        {
            InitializeComponent();
        }

        private void SearchBoxOnRightButtonClick(object sender, RoutedEventArgs e)
        {
            var searchViewModel = (FileSearchViewModel) DataContext;
            searchViewModel.Search();
        }

        private void SearchBoxOnPreviewKeyUp(object sender, KeyEventArgs e)
        {
            if(e.Key != Key.Enter)
                return;

            var searchViewModel = (FileSearchViewModel)DataContext;
            searchViewModel.Search();
        }

        private void LoadMoreButtonClick(object sender, RoutedEventArgs e)
        {
            var searchViewModel = (FileSearchViewModel)DataContext;
            searchViewModel.LoadMore();
        }

        private void ShowFileButtonClick(object sender, RoutedEventArgs e)
        {
            var searchViewModel = (FileSearchViewModel)DataContext;
            var fileId = (Guid) ((Hyperlink) sender).Tag;
            searchViewModel.ShowFileOnDisk(fileId);
        }

        private void Delete(object sender, RoutedEventArgs e)
        {
            var searchViewModel = (FileSearchViewModel)DataContext;
            var selectedItem = searchViewModel.SelectedItem;
            File.Delete(selectedItem.Path);
            searchViewModel.FileItems.Remove(selectedItem);
        }
    }
}
