/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Windows;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using Ascon.Pilot.Theme;
using Ascon.Pilot.Theme.Tools;

namespace Ascon.Pilot.SDK.SearchSample.SourceFileSearch.Tools
{
    public class FileExtToIconConverter : BaseValueConverter
    {
        private readonly Dictionary<string, ImageSource> _icons = new Dictionary<string, ImageSource>();

        protected override object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            var fileName = value as string;
            if (fileName == null)
                return Icons.Instance.RevokedIcon;

            var extention = Path.GetExtension(fileName);

            ImageSource iconImageSource;
            if (_icons.TryGetValue(extention, out iconImageSource))
                return iconImageSource;

            iconImageSource = ExtractIcon(fileName);
            if (iconImageSource == null)
                iconImageSource = Icons.Instance.FileIcon;
            _icons.Add(extention, iconImageSource);
            return iconImageSource;
        }

        private ImageSource ExtractIcon(string fileName)
        {
            try
            {
                var extractedIcon = Icon.ExtractAssociatedIcon(fileName);
                ImageSource imageSource;
                using (Icon i = Icon.FromHandle(extractedIcon.ToBitmap().GetHicon()))
                {
                    imageSource = Imaging.CreateBitmapSourceFromHIcon(i.Handle, new Int32Rect(0, 0, 32, 32), BitmapSizeOptions.FromEmptyOptions());
                }
                return imageSource;
            }
            catch (Exception)
            {

                return null;
            }
        }
    }
}
