/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using System.Reflection;
using System.Windows;

namespace Ascon.Pilot.SDK.StorageSample
{
    class IconLoader
    {
        public static byte[] GetIcon(string relativePath)
        {
            var assembly = Assembly.GetEntryAssembly() ?? Assembly.GetExecutingAssembly();
            Application.ResourceAssembly = assembly;
            var uri = new Uri(relativePath, UriKind.Relative);
            var info = Application.GetResourceStream(uri);
            using (var memoryStream = new MemoryStream())
            {
                if (info == null)
                    return null;

                info.Stream.CopyTo(memoryStream);
                return memoryStream.ToArray();
            }
        }
    }
}
