/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using Ascon.Pilot.SDK;
using DynamicData;
using Moq;
using ProjectCloneWizard.Data;
using ProjectCloneWizard.ObjectsTree;

namespace ProjectCloneWizard.Tests
{
    class TestTools
    {
        public static NodeViewModel GetNodeViewModel(Mock<IDataObject> dataObjectMock, Mock<IDataObjectService> dataObjectServiceMock)
        {
            var node = new Node<IDataObject, Guid>(dataObjectMock.Object, Guid.NewGuid());
            return new NodeViewModel(node, dataObjectServiceMock.Object, false);
        }

        public static Mock<IDataObject> GetIDataObjectMock(Mock<IType> type, Guid id = default(Guid))
        {
            var idataObjectMock = new Mock<IDataObject>();
            idataObjectMock.Setup(d => d.Type).Returns(type.Object);
            idataObjectMock.Setup(d => d.Attributes).Returns(new Dictionary<string, object>());
            idataObjectMock.Setup(d => d.Access2).Returns(new ReadOnlyCollection<IAccessRecord>(new List<IAccessRecord>()));
            idataObjectMock.Setup(d => d.Children).Returns(new ReadOnlyCollection<Guid>(new List<Guid>()));
            idataObjectMock.Setup(d => d.Files).Returns(new ReadOnlyCollection<IFile>(new List<IFile>()));
            idataObjectMock.Setup(d => d.Id).Returns(id);
            return idataObjectMock;
        }

        public static Mock<IDataObject> GetIDataObjectMock(Guid id = default(Guid))
        {
            var type = GetITypeMock();
            return GetIDataObjectMock(type, id);
        }

        internal static NodeViewModel GetNodeViewModel(Guid id = default(Guid))
        {
            var type = GetITypeMock();
            var iobject = GetIDataObjectMock(type, id);
            return GetNodeViewModel(iobject, new Mock<IDataObjectService>());
        }

        public static Mock<IType> GetITypeMock()
        {
            var type = new Mock<IType>();
            type.Setup(t => t.Attributes).Returns(new ReadOnlyCollection<IAttribute>(new List<IAttribute>()));
            type.Setup(t => t.Children).Returns(new ReadOnlyCollection<int>(new List<int>()));
            return type;
        }

        public static Mock<IPerson> GetIPersonMock()
        {
            var personMock = new Mock<IPerson>();
            return personMock;
        }
    }
}
