/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK;
using ProjectCloneWizard.Data;

namespace ProjectCloneWizard.ObjectsTree
{
    public interface IDataObjectServiceFactory
    {
        IDataObjectService GetService();
    }

    class ListViewDataObjectServiceFactory : IDataObjectServiceFactory
    {
        private readonly IObjectsRepository _repository;

        public ListViewDataObjectServiceFactory(IObjectsRepository repository)
        {
            _repository = repository;
        }
        public IDataObjectService GetService()
        {
            var filter = new ListViewChildrenFilter(_repository);
            var service = new DataObjectService(_repository, filter);
            return service;
        }
    }

    class StorageDataObjectServiceFactory : IDataObjectServiceFactory
    {
        private readonly IObjectsRepository _repository;

        public StorageDataObjectServiceFactory(IObjectsRepository repository)
        {
            _repository = repository;
        }
        public IDataObjectService GetService()
        {
            var filter = new StorageChildrenFilter(_repository);
            var service = new DataObjectService(_repository, filter);
            return service;
        }
    }

    class AllDataObjectServiceFactory : IDataObjectServiceFactory
    {
        private readonly IObjectsRepository _repository;

        public AllDataObjectServiceFactory(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public IDataObjectService GetService()
        {
            var filter = new AllChildrenFilter();
            var service = new DataObjectService(_repository, filter);
            return service;
        }
    }
}
