/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;

namespace Pilot.Xps.Domain.Labels
{
    class TextLabelList : List<TextLabel>
    {
        public TextLabelList(string xml)
        {
            var textLabels = XpsTools.TryParseXml(xml);
            if (textLabels == null)
                return;
            var list = new List<TextLabel>();
            foreach (var textBlock in textLabels.Elements(BarcodeLabelsConstants.TEXT_BLOCK))
            {
                if (string.IsNullOrEmpty(textBlock.Value))
                    textBlock.Value = string.Empty;
                var t = new TextLabel(textBlock.ToString());

                list.Add(t);
            }

            Clear();
            AddRange(list);
        }

        public TextLabelList(List<TextLabel> list)
        {
            Clear();
            AddRange(list.ToList());
        }

        public TextLabelList()
        {
            Clear();
        }

        public void ClearOffsetsToLabels()
        {
            foreach (var textLabel in this)
            {
                textLabel.ClearOffsetsToLabel();
            }
        }

        public void SetTextLabelsOffsets(TextLabelList textLabelsToMove)
        {
            var result = textLabelsToMove;

            if (!this.Any())
                return;
            int i = 0;
            foreach (var textLabel in result.Select(x => x.TextLabelXElement))
            {
                if (string.IsNullOrEmpty(textLabel.Value))
                    textLabel.Value = string.Empty;
                var movedTextLabel = this.Select(x => x.TextLabelXElement).ElementAt(i);

                var left = movedTextLabel.Attribute(BarcodeLabelsConstants.CANVAS_LEFT);
                if (left != null)
                    textLabel.SetAttributeValue(BarcodeLabelsConstants.CANVAS_LEFT, left.Value);

                var top = movedTextLabel.Attribute(BarcodeLabelsConstants.CANVAS_TOP);
                if (top != null)
                    textLabel.SetAttributeValue(BarcodeLabelsConstants.CANVAS_TOP, top.Value);

                var verticalAlignment = movedTextLabel.Attribute(BarcodeLabelsConstants.VERTICAL_ALIGNMENT);
                if (verticalAlignment != null)
                    textLabel.SetAttributeValue(BarcodeLabelsConstants.VERTICAL_ALIGNMENT, verticalAlignment.Value);

                var horizontalAlignment = movedTextLabel.Attribute(BarcodeLabelsConstants.HORIZONTAL_ALIGNMENT);
                if (horizontalAlignment != null)
                    textLabel.SetAttributeValue(BarcodeLabelsConstants.HORIZONTAL_ALIGNMENT, horizontalAlignment.Value);

                i++;
            }
        }
    }
}
