/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using System.IO.Packaging;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace Pilot.Xps.Domain.Signatures
{
    [Serializable]
    public class DigitalSignature : ISerializable
    {
        private readonly byte[] _rawBytes;
        public byte[] Data => (byte[])_rawBytes.Clone();

        public Guid SpotId
        {
            get
            {
                using (var stream = new MemoryStream(Data))
                using (var package = Package.Open(stream))
                {
                    return XpsSignatureUtils.GetSignatureId(package);
                }
            }
        }

        public DigitalSignature(byte[] sourseBytes)
        {
            _rawBytes = new byte[sourseBytes.Length];
            sourseBytes.CopyTo(_rawBytes, 0);
        }

        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("rawBytes", _rawBytes, typeof(byte[]));
        }

        public DigitalSignature(SerializationInfo info, StreamingContext context)
        {
            _rawBytes = info.GetValue("rawBytes", typeof(byte[])) as byte[];
        }
    }

    static class DigitalSignatureSerializer
    {
        private class DigitalSignatureBinder : SerializationBinder
        {
            public override Type BindToType(string assemblyName, string typeName)
            {
                return typeof(DigitalSignature);
            }
        }

        public static Stream Serialize(this DigitalSignature ds)
        {
            var ms = new MemoryStream();
            new BinaryFormatter().Serialize(ms, ds);
            return ms;
        }

        public static DigitalSignature Deserialize(Stream stream)
        {
            stream.Position = 0;
            var res = new BinaryFormatter { Binder = new DigitalSignatureBinder() }.Deserialize(stream);
            return res as DigitalSignature;
        }
    }
}
