/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Pilot.Xps.Domain.Signatures
{
    public class SignatureException : Exception
    {
        public bool IsExpected { get; private set; }

        public SignatureException(string message) : base(message) { }
        public SignatureException(string message, Exception innerException) : base(message, innerException) { }

        public SignatureException(string message, bool isExpected) : base(message)
        {
            IsExpected = isExpected;
        }

        public SignatureException(string message, Exception innerException, bool isExpected)
            : base(message, innerException)
        {
            IsExpected = isExpected;
        }
    }
}
