/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace PilotShare.Client.View
{
    interface IPasswordHolder
    {
        string Password { get; set; }
    }

    /// <summary>
    /// Interaction logic for EditLinkView.xaml
    /// </summary>
    public partial class EditLinkView : UserControl, IPasswordHolder
    {
        public EditLinkView()
        {
            InitializeComponent();
        }

        public string Password 
        {
            get => passBox.Password;
            set => passBox.Password = value;
        }

        private void OnPasswordChanged(object sender, RoutedEventArgs e)
        {
            var vm = DataContext as EditLinkViewModel;
            vm?.Validate();
        }

        private void OnSelectedDateChanged(object sender, SelectionChangedEventArgs e)
        {
            var vm = DataContext as EditLinkViewModel;
            vm?.Validate();
        }
    }
}
