/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Menu;
using PilotShare.Client.Properties;

namespace PilotShare.Client.View
{
    [Export(typeof(IMenu<StorageContext>))]
    public class StorageContextMenuExtension : IMenu<StorageContext>, IHandle<UnloadedEventArgs>
    {
        private readonly IPilotShareDialogService _pilotShareDialogService;
        private readonly IEventAggregator _eventAggregator;

        private static string CreateLinkCaption => "miCreateCaption";
        private static string SharedSettingsCaption => "mniSharingSettingsCommand";


        [ImportingConstructor]
        public StorageContextMenuExtension(IEventAggregator eventAggregator, IPilotShareDialogService pilotShareDialogService)
        {
            _eventAggregator = eventAggregator;
            _pilotShareDialogService = pilotShareDialogService;

            _eventAggregator.Subscribe(this);
        }

        public void Build(IMenuBuilder builder, StorageContext context)
        {
            if (context.SelectedObjects.Count() == 1)
            {
                var index = builder.ItemNames.Contains(SharedSettingsCaption)
                    ? builder.ItemNames.ToList().IndexOf(SharedSettingsCaption)
                    : builder.ItemNames.Count() - 1;

                builder.AddItem(CreateLinkCaption, ++index)
                    .WithHeader(Resources.ShareLink)
                    .WithIcon(ResourceLoader.Load("share.png"));
            }
        }

        public void OnMenuItemClick(string name, StorageContext context)
        {
            if (context.SelectedObjects.Count() == 1 && name == CreateLinkCaption)
            {
                var selected = context.SelectedObjects.First();
                _pilotShareDialogService.ShowExternalLinkManager(selected.DataObject);
            }
        }

        public void Handle(UnloadedEventArgs message)
        {
            _eventAggregator.Unsubscribe(this);
        }
    }
}