const fs = require("fs");
const path = require("path");

// Получение текущего рабочего каталога
const currentDir = process.cwd();

// Функция для удаления директории рекурсивно
function removeDirectory(directoryPath) {
  if (
    fs.existsSync(directoryPath) &&
    fs.lstatSync(directoryPath).isDirectory()
  ) {
    fs.rm(directoryPath, { recursive: true, force: true }, (err) => {
      if (err) {
        console.error(`Error removing ${directoryPath}: ${err.message}`);
      } else {
        console.log(`Removed: ${directoryPath}`);
      }
    });
  }
}

// Функция для поиска и удаления всех node_modules и .angular директорий
function findAndRemoveDirectories(startPath) {
  fs.readdir(startPath, { withFileTypes: true }, (err, entries) => {
    if (err) {
      console.error(`Error reading directory ${startPath}: ${err.message}`);
      return;
    }
    entries.forEach((entry) => {
      const fullPath = path.join(startPath, entry.name);
      if (entry.isDirectory()) {
        if (entry.name === "node_modules" || entry.name === ".angular") {
          removeDirectory(fullPath);
        } else {
          findAndRemoveDirectories(fullPath);
        }
      }
    });
  });
}

// Удаление корневой директории node_modules, если она существует
const rootNodesFolder = path.join(currentDir, "node_modules");
removeDirectory(rootNodesFolder);

// Поиск и удаление всех node_modules и .angular директорий в текущем каталоге и его подкаталогах
findAndRemoveDirectories(currentDir);

// Удаление файла package-lock.json, если он существует
const packageLockFile = path.join(currentDir, "package-lock.json");
if (fs.existsSync(packageLockFile)) {
  fs.unlink(packageLockFile, (err) => {
    if (err) {
      console.error(`Error removing ${packageLockFile}: ${err.message}`);
    } else {
      console.log(`Removed: ${packageLockFile}`);
    }
  });
}
