const fs = require('fs');
const path = require('path');

// Path to your package.json
const pkgPath = path.join(__dirname, '../package.json');

// Read package.json
const pkgJson = JSON.parse(fs.readFileSync(pkgPath, 'utf8'));

// Extract scripts
const scripts = Object.keys(pkgJson.scripts);

// Generate concurrently command
let concurrentlyCommand = 'concurrently ';
for (const script of scripts) {
  if (script === "build-concurrently-prod" || script === "build-prod" || script === "clean")
    continue;
  concurrentlyCommand += `"npm run ${script}" `;
}

// Add a new script
pkgJson.scripts["build-concurrently-prod"] = concurrentlyCommand;

// Convert the object back to a JSON string
const newData = JSON.stringify(pkgJson, null, 2); // The second argument adds indentation for readability

// Write the modified data back to package.json
fs.writeFileSync(pkgPath, newData, 'utf8');