import { IPersonalSettings } from "@pilotdev/pilot-web-sdk";
import { describe, expect, test } from "@jest/globals";
import { AdvancementSettingsProvider } from "./advancementSettingsProvider";
import { of, ReplaySubject } from "rxjs";

describe('check advancement settings', () => {
  jest.mock('@pilotdev/pilot-web-sdk', () => ({
    SystemSettingsKeys: {
      advancedSignatureFeatureKey: 'advancedSignatureFeatureKey',
    },
    IPersonalSettings: jest.fn(),
  }));

  beforeEach(() => {
  });

  const settings = ['issuer1', 'issuer2'];

  const settingsMock = <IPersonalSettings> {
    getPersonalSettingValue: jest.fn(() => of(undefined)),
    subscribePersonalSettingValueChange: jest.fn((key: string) => of(undefined)),
    getCommonSettingValue: jest.fn((key: string) => of(settings)),
    subscribeCommonSettingValueChange: jest.fn((key: string) => of(settings)),
    changeSettingValue: jest.fn(() => of()),
  };

  test('should parse advancement settings', () => {
    const cancel = new ReplaySubject<void>(1);

    // given
    const provider = new AdvancementSettingsProvider(settingsMock);

    // when
    provider.initialize(cancel);

    // then
    expect(provider.getSettings()).toBeTruthy();
  });

});