/**
 * Copyright (c) 2024 ASCON-Design Systems LLC. All rights reserved.
 * This sample is licensed under the MIT License.
 */

import { Injectable } from '@angular/core';
import { ITabs, ITabsBuilder, ObjectsViewContext } from '@pilotdev/pilot-web-sdk';

export const AngularTabId = 'AngularSample_DemoAngularTab';
export const TableTabId = 'AngularSample_DemoTableTab';

const angularIcon =
  'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBzdHJva2U9ImN1cnJlbnRDb2xvciIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiIGNsYXNzPSJsdWNpZGUgbHVjaWRlLWJpbmFyeSI+PHJlY3QgeD0iMTQiIHk9IjE0IiB3aWR0aD0iNCIgaGVpZ2h0PSI2IiByeD0iMiIvPjxyZWN0IHg9IjYiIHk9IjQiIHdpZHRoPSI0IiBoZWlnaHQ9IjYiIHJ4PSIyIi8+PHBhdGggZD0iTTYgMjBoNCIvPjxwYXRoIGQ9Ik0xNCAxMGg0Ii8+PHBhdGggZD0iTTYgMTRoMnY2Ii8+PHBhdGggZD0iTTE0IDRoMnY2Ii8+PC9zdmc+';

const tableIcon =
  'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBzdHJva2U9ImN1cnJlbnRDb2xvciIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiIGNsYXNzPSJsdWNpZGUgbHVjaWRlLXRhYmxlLXByb3BlcnRpZXMiPjxwYXRoIGQ9Ik0xNSAzdjE4Ii8+PHJlY3Qgd2lkdGg9IjE4IiBoZWlnaHQ9IjE4IiB4PSIzIiB5PSIzIiByeD0iMiIvPjxwYXRoIGQ9Ik0yMSA5SDMiLz48cGF0aCBkPSJNMjEgMTVIMyIvPjwvc3ZnPg==';

@Injectable({providedIn: "root"})
export class DocumentTabsExtensionSample implements ITabs<ObjectsViewContext> {
  build(builder: ITabsBuilder, context: ObjectsViewContext): void {
    if (context.selectedObjects[0].type.hasFiles) {
      builder
        .addItem(AngularTabId, 1)
        .withTitle('Angular Start Demo')
        .withIcon('demo-angular-tab', angularIcon)
        .withViewId(AngularTabId);

      builder
        .addItem(TableTabId, 2)
        .withTitle('Table Demo')
        .withIcon('demo-table-tab', tableIcon)
        .withViewId(TableTabId)
    }
  }
}
