import { ICertificate } from "@pilotdev/pilot-web-sdk";
import { root, rootCert, rogova, rogovaCert, rogovaPrivateKey, sedov, sedovCert, sedovPrivateKey } from "./certificate.consts";
import { X509 } from "jsrsasign";
import { toJsDate } from "./utils";
import { JsRsaSignAdapter } from "./jsrsasign.adapter";

class SimpleCertificate {
  cert: string;
  privateKey?: string;
}

export class CertificatesStore {

  private readonly _certificates = new Map<string, SimpleCertificate>([
    [sedov, { cert: sedovCert,  privateKey: sedovPrivateKey}],
    [rogova, { cert: rogovaCert,  privateKey: rogovaPrivateKey}],
    [root, { cert: rootCert }],
  ]);

  get rootCertificate(): ICertificate {
    const certReader = new X509();
    certReader.readCertPEM(rootCert);
    return {
      issuer: certReader.getIssuerString(), 
      subject: certReader.getSubjectString(),
      thumbprint: certReader.getSerialNumberHex(),
      validFromDate: toJsDate(certReader.getNotBefore()),
      validToDate: toJsDate(certReader.getNotAfter()),
      publicKeyOid: JsRsaSignAdapter.signatureAlgorithm
    };
  }

  getCertificates(): ICertificate[] {
    const certReader = new X509();
    certReader.readCertPEM(sedovCert);
    const sedov: ICertificate = {
      issuer: certReader.getIssuerString(), 
      subject: certReader.getSubjectString(),
      thumbprint: certReader.getSerialNumberHex(),
      validFromDate: toJsDate(certReader.getNotBefore()),
      validToDate: toJsDate(certReader.getNotAfter()),
      publicKeyOid: JsRsaSignAdapter.signatureAlgorithm
    };
    certReader.readCertPEM(rogovaCert);
    const rogova: ICertificate = {
      issuer: certReader.getIssuerString(), 
      subject: certReader.getSubjectString(),
      thumbprint: certReader.getSerialNumberHex(),
      validFromDate: toJsDate(certReader.getNotBefore()),
      validToDate: toJsDate(certReader.getNotAfter()),
      publicKeyOid: JsRsaSignAdapter.signatureAlgorithm
    }
    return [ sedov, rogova ];
  }

  getPrivateKey(user: string): string | undefined {
    return this._certificates.get(user)?.privateKey;
  }

  getCertificate(user: string): string | undefined {
    return this._certificates.get(user)?.cert;
  }
}