import { FileData, SortColumn, SortDirection } from './models';

export const handleSort = (data: FileData[], sortField: SortColumn, sortDirection: SortDirection): FileData[] => {
  return [...data].sort((a, b) => {
    return (
      a[sortField].toString().localeCompare(b[sortField].toString(), ['en', 'ru'], { numeric: true }) *
      (sortDirection === SortDirection.Asc ? 1 : -1)
    );
  });
};
