const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
const CopyPlugin = require('copy-webpack-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const ESLintWebpackPlugin = require('eslint-webpack-plugin');

module.exports =
{
  mode: 'development',
  entry: { main: './src/index.tsx' },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
      {
        test: /\.css$/i,
        use: [
          'style-loader',
          { loader: 'css-loader', options: { modules: true } },
        ],
      },
    ],
  },
  resolve: {
    extensions: ['.tsx', '.ts', '.jsx', '.js', '.json'],
  },
  output: {
    publicPath: 'auto',
    uniqueName: 'document_explorer_tabs_extension_sample',
    scriptType: 'text/javascript',
    filename: '[name].js',
    clean: true,
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false,
  },
  plugins: [
    new ESLintWebpackPlugin(),
    new HtmlWebpackPlugin({
      template: './src/index.html',
    }),
    new ModuleFederationPlugin({
      name: 'tabs_extension_sample',
      library: {
        type: 'var',
        name: 'tabs_extension_sample',
      },
      filename: '[name].js',
      exposes: [
        {
          'ITabs<ObjectsViewContext>':
            './src/extension/tabsExtensionSample.ts',
        },
        {
          'IOpenspaceView<ObjectsViewContext>':
            './src/extension/tabsExtensionSample.ts',
        },
      ],
      shared: {
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        },
      },
    }),
    new CopyPlugin({
      patterns: [
        {
          from: './src/extension/extensions.config.json',
          to: 'extensions.config.json',
        },
      ],
    }),
  ],
  devServer: {
    port: 4300,
    allowedHosts: 'auto',
    headers: {
      'Access-Control-Allow-Origin': '*',
    },
  },
};
