#!/bin/sh 
CONFIGURATION="debug"
BUILD_DIRECTORY="bin/build"
CAJA_EXTENSIONS_DIRECTORY="/usr/lib/x86_64-linux-gnu/caja/extensions-2.0"
PLUGIN_PATH=$BUILD_DIRECTORY"/libcaja-3DStorage.so"
SRC_DIRECTORY=`dirname "$0"`"/src/3DStorage.CajaExtension"

if mkdir -p "$CAJA_EXTENSIONS_DIRECTORY"; then
    echo "Directory '$CAJA_EXTENSIONS_DIRECTORY' was created or already exists."
else
    echo " Failed to create directory '$CAJA_EXTENSIONS_DIRECTORY'."
    exit 1
fi

cmake -S echo $SRC_DIRECTORY -B $BUILD_DIRECTORY -G "Unix Makefiles" -DCMAKE_EXPORT_COMPILE_COMMANDS:BOOL=TRUE -DCMAKE_BUILD_TYPE:STRING=$CONFIGURATION -DCMAKE_C_COMPILER:FILEPATH=/usr/bin/gcc -DCMAKE_CXX_COMPILER:FILEPATH=/usr/bin/g++
cmake --build $BUILD_DIRECTORY --config $CONFIGURATION


echo 'Install libcaja-3DStorage.so to '$CAJA_EXTENSIONS_DIRECTORY
sudo cp $PLUGIN_PATH $CAJA_EXTENSIONS_DIRECTORY
