﻿using Newtonsoft.Json;
using System.Collections.Generic;

namespace BcfApiService.DTOs
{
    public class ProjectDTO
    {
        [JsonProperty("project_id")]
        public string ProjectId { get; set; }

        [JsonProperty("name")]
        public string Name { get; set; }

        [JsonProperty("authorization", NullValueHandling = NullValueHandling.Ignore)]
        public Authorization Authorization { get; set; }
    }

    public class Authorization
    {
        [JsonProperty("project_actions")]
        public List<ProjectAction> ProjectActions { get; set; }
    }

    public enum ProjectAction
    {
        Update,
        CreateTopic,
        CreateDocument
    }
}
