﻿using Ascon.Pilot.SDK;
using System;
using System.Threading.Tasks;

namespace BcfApiService.Loaders
{
    public class ObjectIdsByTypeIdLoader : IObserver<ISearchResult>
    {
        private readonly ISearchService _searchService;
        private IDisposable _subscription;
        private TaskCompletionSource<ISearchResult> _tcs;

        public ObjectIdsByTypeIdLoader(ISearchService searchService)
        {
            _searchService = searchService;
        }

        public Task<ISearchResult> Load(int id)
        {
            IQueryBuilder builder = _searchService.GetObjectQueryBuilder();
            builder.Must(ObjectFields.TypeId.Be(id));
            _tcs = new TaskCompletionSource<ISearchResult>();
            _subscription = _searchService.Search(builder).Subscribe(this);
            return _tcs.Task;
        }

        public void OnNext(ISearchResult value)
        {
            _tcs.TrySetResult(value);
            _subscription.Dispose();
        }

        public void OnError(Exception error) { }

        public void OnCompleted() { }
    }
}
