/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.Controls.ObjectCardView.ElementBook
{
    public interface IElementBookUtils
    {
        bool CanCreateElementBook(IDataObject obj, IElementBookDescription config);
        string GetEffectiveAttributeTitle(IDataObject obj, string stringFormat);
    }

    public class ElementBookUtils : IElementBookUtils
    {
        private IObjectsRepository _repository;
        private IPerson _person;

        public ElementBookUtils(IObjectsRepository repository)
        {
            _repository = repository;
            _person = _repository.GetCurrentPerson();
        }

        public bool CanCreateElementBook(IDataObject obj, IElementBookDescription config)
        {
            if (obj.State != DataState.Loaded || obj.ObjectStateInfo.State == ObjectState.DeletedPermanently || obj.ObjectStateInfo.State == ObjectState.InRecycleBin)
                return false;

            var access = _repository.GetCurrentAccess(obj.Id, _person.Id);
            if (!access.HasFlag(AccessLevel.View))
                return false;

            if (config.ElementsTypes != null && config.ElementsTypes.Any())
                return config.ElementsTypes.Contains(obj.Type.Name);

            return true;
        }

        public string GetEffectiveAttributeTitle(IDataObject obj, string stringFormat)
        {
            var formattedTitle = string.IsNullOrEmpty(stringFormat)
                ? obj.DisplayName
                : stringFormat.Format((IReadOnlyDictionary<string, object>)obj.Attributes, CultureInfo.CurrentCulture);
            return formattedTitle;
        }
    }
}
