/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using Ascon.Pilot.SDK.Menu;

namespace Ascon.Pilot.SDK.MainMenuSample
{
    [Export(typeof(IMenu<MainViewContext>))]
    public class MainMenuPlugin : IMenu<MainViewContext>
    {
        private const string SERVICE_MY_MENU = "ServiceMyMenu";
        private const string MY_SUB_MENU = "MySubMenu";
        
        public void Build(IMenuBuilder builder, MainViewContext context)
        {
            var menuItem = builder.ItemNames.First();
            builder.GetItem(menuItem).AddItem(SERVICE_MY_MENU, 0).WithHeader("My menu in service");

            var item = builder.AddItem("MyMenu", 1).WithHeader("My menu");
            item.WithSubmenu().AddItem(MY_SUB_MENU, 0).WithHeader("Submenu item");
        }

        public void OnMenuItemClick(string name, MainViewContext context)
        {
            if (name == SERVICE_MY_MENU)
                MessageBox.Show("\"My menu in service\" was clicked");

            if (name == MY_SUB_MENU)
                MessageBox.Show("\"Submenu item\" was clicked");
        }
    }
}
