/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.PrinterSample
{
    [Export(typeof(IPrintHandler))]
    public class PrintHandler: IPrintHandler
    {
        private readonly IObjectsRepository _repository;

        [ImportingConstructor]
        public PrintHandler(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public bool Handle(IPrintedDocumentInfo printTicket)
        {
            var message = new StringBuilder();
            message.AppendLine("We not allow to print document");
            message.Append("NAME: ");
            message.AppendLine(printTicket.PrinterSettings.PrintJobName);
            message.Append("ID: ");
            message.Append(printTicket.DocumentId);

            MessageBox.Show(message.ToString(), "Something works", MessageBoxButton.OK, MessageBoxImage.Information);
            if (printTicket.DocumentId != Guid.Empty)
            {
                Task.Factory.StartNew(async () =>
                {
                    var loader = new ObjectLoader(_repository);
                    var obj = await loader.Load(printTicket.DocumentId);
                    var mess = new StringBuilder();
                    foreach (var file in obj.Files)
                    {
                        mess.AppendLine("Name " + file.Name);
                    }

                    MessageBox.Show(mess.ToString(), "Files to print", MessageBoxButton.OK,
                        MessageBoxImage.Information);
                });
            }

            return true;
        }
    }
}