/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;
using System.Windows;

namespace Ascon.Pilot.SDK.SettingsSample
{
    [Export(typeof(ISettingsFeature2))]
    public class SampleSettingsFeature : ISettingsFeature2
    {
        private ISettingValueProvider _settingValueProvider;

        public void SetValueProvider(ISettingValueProvider settingValueProvider)
        {
            _settingValueProvider = settingValueProvider;
        }

        public string Key => SettingsFeatureKeys.SampleFeatureKey;

        public string Title => "Sample setting";

        public FrameworkElement Editor
        {
            get
            {
                var editorViewModel = new SettingsFeatureEditorViewModel(_settingValueProvider);
                var editor = new SettingFeatureEditor
                {
                    DataContext = editorViewModel
                };
                return editor;
            }
        }

        public bool IsValid(string settingsItemValue)
        {
            return true;
        }
    }

    [Export(typeof(ISettingsFeature2))]
    public class SampleSettingsFeature2 : ISettingsFeature2
    {
        public void SetValueProvider(ISettingValueProvider settingValueProvider)
        {
            
        }

        public string Key => SettingsFeatureKeys.Sample2FeatureKey;

        public string Title => "Sample setting 2";

        public FrameworkElement Editor => null;
        public bool IsValid(string settingsItemValue)
        {
            return true;
        }
    }
}
