/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;

namespace Ascon.Pilot.SDK.TaskSample.Services
{
    public interface IPilotServices
    {
        IObjectModifier ObjectModifier { get; }
        IObjectsRepository ObjectsRepository { get; }
        IPilotDialogService PilotDialogService { get; }
        ITabServiceProvider TabServiceProvider { get; }
        IAttributeFormatParser AttributeFormatParser { get; }
        IElementBookAutoFillWorker ElementBookAutoFillWorker { get; }
        ITransitionManager TransitionManager { get; }
    }

    [Export(typeof(IPilotServices))]
    class PilotServices : IPilotServices
    {
        [ImportingConstructor]
        public PilotServices(IObjectModifier objectModifier, IObjectsRepository objectsRepository, 
            IPilotDialogService pilotDialogService, ITabServiceProvider tabServiceProvider, IAttributeFormatParser attributeFormatParser, IElementBookAutoFillWorker elementBookWorker, ITransitionManager transitionManager)
        {
            ObjectModifier = objectModifier;
            ObjectsRepository = objectsRepository;
            PilotDialogService = pilotDialogService;
            TabServiceProvider = tabServiceProvider;
            AttributeFormatParser = attributeFormatParser;
            ElementBookAutoFillWorker = elementBookWorker;
            TransitionManager = transitionManager;
        }
        public IObjectModifier ObjectModifier { get; }
        public IObjectsRepository ObjectsRepository { get; }
        public IPilotDialogService PilotDialogService { get; }
        public ITabServiceProvider TabServiceProvider { get; }
        public IAttributeFormatParser AttributeFormatParser { get; }
        public IElementBookAutoFillWorker ElementBookAutoFillWorker { get; set; }
        public ITransitionManager TransitionManager { get; set; }
    }
}
