﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Windows;
using System.Windows.Controls;

namespace PdfStamper.ViewModels
{
    public class SettingTemplateSelector : DataTemplateSelector
    {
        public DataTemplate SignatureTemplate { get; set; }
        public DataTemplate IntoProductionTemplate { get; set; }

        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            var viewModel = (BaseSettingViewModel)item;
            if (viewModel == null)
                return null;

            if (viewModel is SignatureSettingViewModel)
                return SignatureTemplate;

            if (viewModel is IntoProductionSettingViewModel)
                return IntoProductionTemplate;

            throw new NotSupportedException();
        }
    }
}