/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Windows;
using Ascon.Pilot.SDK;
using PilotShare.Client.Utils;
using IDataObject = Ascon.Pilot.SDK.IDataObject;

namespace PilotShare.Client.View
{
    class CreateLinkViewModel : EditLinkViewModel
    {
        private readonly IDataObject _target;
        private readonly IObjectsRepository _repository;

        public CreateLinkViewModel(IDataObject target, LinkItem link, ILinkObjectModifier modifier, IPasswordHolder passwordHolder, IObjectsRepository repository) 
            : base(link, modifier, passwordHolder)
        {
            _target = target;
            _repository = repository;
        }

        protected override void Submit()
        {
            _link.Password = _passwordHolder.Password;
            _link.ValidThrough = ExpirationDate;
            _link.Date = DateTime.Now;
            _link.SharedBy = _repository.GetCurrentPerson().DisplayName;

            var dispatcher = new ContextDispatcher(Application.Current.Dispatcher);
            _modifier.CreateLink(_link, _target, dispatcher);
            CloseView(true);
        }

        protected override bool CanSubmit()
        {
            return true;
        }
    }
}
