// get more information https://docs.cryptopro.ru/cades/reference/cadescom/cadescom_class

declare namespace cadesplugin {
  const JSModuleVersion: string;
  function async_spawn (generatorFunc: any, ...args: any[]): any;
  function set (obj: any): void;
  function set_log_level (level: any): void;
  function get_extension_version (callback: any): void;
  function get_extension_id (callback: any): void;
  function getLastError (exception: any): any;
  function is_capilite_enabled (): any;
  function CreateObjectAsync (name: any): any;
  function ReleasePluginObjects (): any;
  function CreateObject (name: any): any;
  const current_log_level: any;

  declare const CAPICOM_MEMORY_STORE;
  declare const CAPICOM_LOCAL_MACHINE_STORE;
  declare const CAPICOM_CURRENT_USER_STORE;
  declare const CAPICOM_SMART_CARD_USER_STORE;
  declare const CADESCOM_MEMORY_STORE;
  declare const CADESCOM_LOCAL_MACHINE_STORE;
  declare const CADESCOM_CURRENT_USER_STORE;
  declare const CADESCOM_SMART_CARD_USER_STORE;
  declare const CADESCOM_CONTAINER_STORE;

  declare const CAPICOM_ROOT_STORE;
  declare const CAPICOM_CA_STORE;
  declare const CAPICOM_MY_STORE;
  declare const CAPICOM_ADDRESSBOOK_STORE;

  declare const CAPICOM_STORE_OPEN_READ_WRITE;
  declare const CAPICOM_STORE_OPEN_MAXIMUM_ALLOWED;
  declare const CAPICOM_STORE_OPEN_INCLUDE_ARCHIVED;

  declare const CAPICOM_CERTIFICATE_FIND_SUBJECT_NAME;

  declare const CADESCOM_XML_SIGNATURE_TYPE_ENVELOPED;
  declare const CADESCOM_XML_SIGNATURE_TYPE_ENVELOPING;
  declare const CADESCOM_XML_SIGNATURE_TYPE_TEMPLATE;

  declare const CADESCOM_XADES_DEFAULT;
  declare const CADESCOM_XADES_BES;
  declare const CADESCOM_XADES_T;
  declare const CADESCOM_XADES_X_LONG_TYPE_1;
  declare const CADESCOM_XMLDSIG_TYPE;

  declare const XmlDsigGost3410UrlObsolete;
  declare const XmlDsigGost3411UrlObsolete;
  declare const XmlDsigGost3410Url;
  declare const XmlDsigGost3411Url;

  declare const XmlDsigGost3411Url2012256;
  declare const XmlDsigGost3410Url2012256;
  declare const XmlDsigGost3411Url2012512;
  declare const XmlDsigGost3410Url2012512;

  declare const CADESCOM_CADES_DEFAULT;
  declare const CADESCOM_CADES_BES;
  declare const CADESCOM_CADES_T;
  declare const CADESCOM_CADES_X_LONG_TYPE_1;
  declare const CADESCOM_CADES_A;
  declare const CADESCOM_PKCS7_TYPE;

  declare const CADESCOM_ENCODE_BASE64;
  declare const CADESCOM_ENCODE_BINARY;
  declare const CADESCOM_ENCODE_ANY;

  declare const CAPICOM_CERTIFICATE_INCLUDE_CHAIN_EXCEPT_ROOT;
  declare const CAPICOM_CERTIFICATE_INCLUDE_WHOLE_CHAIN;
  declare const CAPICOM_CERTIFICATE_INCLUDE_END_ENTITY_ONLY;
  declare const CAPICOM_CERTIFICATE_INCLUDE_NONE;

  declare const CAPICOM_CERT_INFO_SUBJECT_SIMPLE_NAME;
  declare const CAPICOM_CERT_INFO_ISSUER_SIMPLE_NAME;

  declare const CAPICOM_CERTIFICATE_FIND_SHA1_HASH;
  declare const CAPICOM_CERTIFICATE_FIND_SUBJECT_NAME;
  declare const CAPICOM_CERTIFICATE_FIND_ISSUER_NAME;
  declare const CAPICOM_CERTIFICATE_FIND_ROOT_NAME;
  declare const CAPICOM_CERTIFICATE_FIND_TEMPLATE_NAME;
  declare const CAPICOM_CERTIFICATE_FIND_EXTENSION;
  declare const CAPICOM_CERTIFICATE_FIND_EXTENDED_PROPERTY;
  declare const CAPICOM_CERTIFICATE_FIND_APPLICATION_POLICY;
  declare const CAPICOM_CERTIFICATE_FIND_CERTIFICATE_POLICY;
  declare const CAPICOM_CERTIFICATE_FIND_TIME_VALID;
  declare const CAPICOM_CERTIFICATE_FIND_TIME_NOT_YET_VALID;
  declare const CAPICOM_CERTIFICATE_FIND_TIME_EXPIRED;
  declare const CAPICOM_CERTIFICATE_FIND_KEY_USAGE;

  declare const CAPICOM_DIGITAL_SIGNATURE_KEY_USAGE;

  declare const CAPICOM_PROPID_ENHKEY_USAGE;

  declare const CAPICOM_OID_OTHER;
  declare const CAPICOM_OID_KEY_USAGE_EXTENSION;

  declare const CAPICOM_EKU_CLIENT_AUTH;
  declare const CAPICOM_EKU_SMARTCARD_LOGON;
  declare const CAPICOM_EKU_OTHER;

  declare const CAPICOM_AUTHENTICATED_ATTRIBUTE_SIGNING_TIME;
  declare const CAPICOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_NAME;
  declare const CAPICOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_DESCRIPTION;
  declare const CADESCOM_AUTHENTICATED_ATTRIBUTE_SIGNING_TIME;
  declare const CADESCOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_NAME;
  declare const CADESCOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_DESCRIPTION;
  declare const CADESCOM_AUTHENTICATED_ATTRIBUTE_MACHINE_INFO;
  declare const CADESCOM_ATTRIBUTE_OTHER;

  declare const CADESCOM_STRING_TO_UCS2LE;
  declare const CADESCOM_BASE64_TO_BINARY;

  declare const CADESCOM_DISPLAY_DATA_NONE;
  declare const CADESCOM_DISPLAY_DATA_CONTENT;
  declare const CADESCOM_DISPLAY_DATA_ATTRIBUTE;

  declare const CADESCOM_ENCRYPTION_ALGORITHM_RC2;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_RC4;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_DES;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_3DES;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_AES;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_GOST_28147_89;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_GOST_MAGMA;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_GOST_MAGMA_OMAC;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_GOST_KUZNYECHIK;
  declare const CADESCOM_ENCRYPTION_ALGORITHM_GOST_KUZNYECHIK_OMAC;

  declare const CADESCOM_HASH_ALGORITHM_SHA1;
  declare const CADESCOM_HASH_ALGORITHM_MD2;
  declare const CADESCOM_HASH_ALGORITHM_MD4;
  declare const CADESCOM_HASH_ALGORITHM_MD5;
  declare const CADESCOM_HASH_ALGORITHM_SHA_256;
  declare const CADESCOM_HASH_ALGORITHM_SHA_384;
  declare const CADESCOM_HASH_ALGORITHM_SHA_512;
  declare const CADESCOM_HASH_ALGORITHM_CP_GOST_3411;
  declare const CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_256;
  declare const CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_512;
  declare const CADESCOM_HASH_ALGORITHM_CP_GOST_3411_HMAC;
  declare const CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_256_HMAC;
  declare const CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_512_HMAC;

  declare const CADESCOM_CERT_INFO_ROLE;
  declare const CADESCOM_ROLE_ROOT;
  declare const CADESCOM_ROLE_CA;
  declare const CADESCOM_ROLE_LEAF;

  declare const LOG_LEVEL_DEBUG;
  declare const LOG_LEVEL_INFO;
  declare const LOG_LEVEL_ERROR;

  declare const CADESCOM_AllowNone;
  declare const CADESCOM_AllowNoOutstandingRequest;
  declare const CADESCOM_AllowUntrustedCertificate;
  declare const CADESCOM_AllowUntrustedRoot;
  declare const CADESCOM_SkipInstallToStore;
  declare const CADESCOM_InstallCertChainToContainer;
  declare const CADESCOM_UseContainerStore;

  declare const ContextNone;
  declare const ContextUser;
  declare const ContextMachine;
  declare const ContextAdministratorForceMachine;

  declare const ENABLE_CARRIER_TYPE_CSP;
  declare const ENABLE_CARRIER_TYPE_FKC_NO_SM;
  declare const ENABLE_CARRIER_TYPE_FKC_SM;
  declare const ENABLE_ANY_CARRIER_TYPE;

  declare const DISABLE_EVERY_CARRIER_OPERATION;
  declare const ENABLE_CARRIER_OPEN_ENUM;
  declare const ENABLE_CARRIER_CREATE;
  declare const ENABLE_ANY_OPERATION;

  declare const CADESCOM_PRODUCT_CSP;
  declare const CADESCOM_PRODUCT_OCSP;
  declare const CADESCOM_PRODUCT_TSP;

  declare const MEDIA_TYPE_DEFAULT;
  declare const MEDIA_TYPE_REGISTRY;
  declare const MEDIA_TYPE_HDIMAGE;
  declare const MEDIA_TYPE_CLOUD;
  declare const MEDIA_TYPE_SCARD;

  declare const XCN_CRYPT_STRING_BASE64HEADER;
  declare const XCN_CRYPT_STRING_BASE64;
  declare const XCN_CRYPT_STRING_BINARY;
  declare const XCN_CRYPT_STRING_BASE64REQUESTHEADER;
  declare const XCN_CRYPT_STRING_HEX;
  declare const XCN_CRYPT_STRING_HEXASCII;
  declare const XCN_CRYPT_STRING_BASE64_ANY;
  declare const XCN_CRYPT_STRING_ANY;
  declare const XCN_CRYPT_STRING_HEX_ANY;
  declare const XCN_CRYPT_STRING_BASE64X509CRLHEADER;
  declare const XCN_CRYPT_STRING_HEXADDR;
  declare const XCN_CRYPT_STRING_HEXASCIIADDR;
  declare const XCN_CRYPT_STRING_HEXRAW;
  declare const XCN_CRYPT_STRING_BASE64URI;
  declare const XCN_CRYPT_STRING_ENCODEMASK;
  declare const XCN_CRYPT_STRING_CHAIN;
  declare const XCN_CRYPT_STRING_TEXT;
  declare const XCN_CRYPT_STRING_PERCENTESCAPE;
  declare const XCN_CRYPT_STRING_HASHDATA;
  declare const XCN_CRYPT_STRING_STRICT;
  declare const XCN_CRYPT_STRING_NOCRLF;
  declare const XCN_CRYPT_STRING_NOCR;

  declare const XCN_CERT_NAME_STR_NONE;
  declare const XCN_AT_NONE;
  declare const XCN_AT_KEYEXCHANGE;
  declare const XCN_AT_SIGNATURE;

  declare const AT_KEYEXCHANGE;
  declare const AT_SIGNATURE;

  declare const CARRIER_FLAG_REMOVABLE;
  declare const CARRIER_FLAG_UNIQUE;
  declare const CARRIER_FLAG_PROTECTED;
  declare const CARRIER_FLAG_FUNCTIONAL_CARRIER;
  declare const CARRIER_FLAG_SECURE_MESSAGING;
  declare const CARRIER_FLAG_ABLE_SET_KEY;
  declare const CARRIER_FLAG_ABLE_VISUALISE_SIGNATURE;
  declare const CARRIER_FLAG_VIRTUAL;

  declare const CRYPT_MODE_CBCSTRICT;
  declare const CRYPT_MODE_CNT;
  declare const CRYPT_MODE_CBCRFC4357;
  declare const CRYPT_MODE_CTR;
  declare const CRYPT_MODE_MGM;
  declare const CRYPT_MODE_GCM;
  declare const CRYPT_MODE_OMAC_CTR;
  declare const CRYPT_MODE_WRAP;
  declare const CRYPT_MODE_WRAP_PAD;

  declare const PKCS5_PADDING;
  declare const RANDOM_PADDING;
  declare const ZERO_PADDING;
  declare const ISO10126_PADDING;
  declare const ANSI_X923_PADDING;
  declare const TLS_1_0_PADDING;
  declare const ISO_IEC_7816_4_PADDING;

  declare const CAPICOM_STORE_SAVE_AS_SERIALIZED;
  declare const CAPICOM_STORE_SAVE_AS_PKCS7;

  declare const CERT_TRUST_NO_ERROR;
  declare const CERT_TRUST_IS_NOT_TIME_VALID;
  declare const CERT_TRUST_IS_REVOKED;
  declare const CERT_TRUST_IS_NOT_SIGNATURE_VALID;
  declare const CERT_TRUST_IS_NOT_VALID_FOR_USAGE;
  declare const CERT_TRUST_IS_UNTRUSTED_ROOT;
  declare const CERT_TRUST_REVOCATION_STATUS_UNKNOWN;
  declare const CERT_TRUST_IS_CYCLIC;
  declare const CERT_TRUST_INVALID_EXTENSION;
  declare const CERT_TRUST_INVALID_POLICY_CONSTRAINTS;
  declare const CERT_TRUST_INVALID_BASIC_CONSTRAINTS;
  declare const CERT_TRUST_INVALID_NAME_CONSTRAINTS;
  declare const CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT;
  declare const CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT;
  declare const CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT;
  declare const CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT;
  declare const CERT_TRUST_IS_OFFLINE_REVOCATION;
  declare const CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY;
  declare const CERT_TRUST_IS_EXPLICIT_DISTRUST;
  declare const CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT;
  declare const CERT_TRUST_HAS_WEAK_SIGNATURE;

  declare const XCN_CERT_NO_KEY_USAGE;
  declare const XCN_CERT_DIGITAL_SIGNATURE_KEY_USAGEx80;
  declare const XCN_CERT_NON_REPUDIATION_KEY_USAGEx40;
  declare const XCN_CERT_KEY_ENCIPHERMENT_KEY_USAGEx20;
  declare const XCN_CERT_DATA_ENCIPHERMENT_KEY_USAGEx10;
  declare const XCN_CERT_KEY_AGREEMENT_KEY_USAGEx8;
  declare const XCN_CERT_KEY_CERT_SIGN_KEY_USAGEx4;
  declare const XCN_CERT_OFFLINE_CRL_SIGN_KEY_USAGEx2;
  declare const XCN_CERT_CRL_SIGN_KEY_USAGEx2;
  declare const XCN_CERT_ENCIPHER_ONLY_KEY_USAGEx1;
  declare const XCN_CERT_DECIPHER_ONLY_KEY_USAGEx8000;

  declare const CADESCOM_XADES_ACCEPT_ANY_ID_ATTR_NAMESPACE;
  declare const CADES_USE_OCSP_AUTHORIZED_POLICYx00020000;

  declare const XCN_NCRYPT_NO_OPERATION;
  declare const XCN_NCRYPT_CIPHER_OPERATIONx1;
  declare const XCN_NCRYPT_HASH_OPERATIONx2;
  declare const XCN_NCRYPT_ASYMMETRIC_ENCRYPTION_OPERATIONx4;
  declare const XCN_NCRYPT_SECRET_AGREEMENT_OPERATIONx8;
  declare const XCN_NCRYPT_SIGNATURE_OPERATIONx10;
  declare const XCN_NCRYPT_RNG_OPERATIONx20;

  declare const XCN_CRYPT_ANY_GROUP_ID;
  declare const XCN_CRYPT_HASH_ALG_OID_GROUP_ID;
  declare const XCN_CRYPT_ENCRYPT_ALG_OID_GROUP_ID;
  declare const XCN_CRYPT_PUBKEY_ALG_OID_GROUP_ID;
  declare const XCN_CRYPT_SIGN_ALG_OID_GROUP_ID;
  declare const XCN_CRYPT_RDN_ATTR_OID_GROUP_ID;
  declare const XCN_CRYPT_EXT_OR_ATTR_OID_GROUP_ID;
  declare const XCN_CRYPT_ENHKEY_USAGE_OID_GROUP_ID;
  declare const XCN_CRYPT_POLICY_OID_GROUP_ID;
  declare const XCN_CRYPT_TEMPLATE_OID_GROUP_ID;

  declare const XCN_CRYPT_OID_INFO_PUBKEY_ANY;
  declare const XCN_CRYPT_OID_INFO_PUBKEY_SIGN_KEY_FLAGx80000000;
  declare const XCN_CRYPT_OID_INFO_PUBKEY_ENCRYPT_KEY_FLAGx40000000;

  declare const CONTROL_KEY_TIME_VALIDITY_DISABLED;
  declare const CONTROL_KEY_TIME_VALIDITY_ENABLED;
  declare const CONTROL_KEY_TIME_VALIDITY_STRICT;

  declare const AlgorithmFlagsNone;
  declare const AlgorithmFlagsWrapx1;
}

declare global {
  interface Window {
    cadesplugin: cadesplugin;
  }
}

declare interface ICadesException {
  message: string;
  requestid: number;
  type: string;
}

declare interface ICryptoProEventSource {
  addEventListener: (event: Event, listener: (e: Event) => {}, capture: boolean) => {};
  removeEventListener : (event: Event, listener: (e: Event) => {}, capture: boolean) => {};
}

declare interface ICryptoProSigner {
  objid: number;
  AdditionalTSAAddress: () => Promise<{}>;
  AuthenticatedAttributes: Promise<{} | ICadesException>;
  AuthenticatedAttributes2: Promise<{} | ICadesException>;
  CRLs: Promise<{} | ICadesException>;
  Certificate: Promise<ICryptoProCertificate>;
  CheckCertificate: Promise<{} | ICadesException>;
  KeyPin: Promise<{} | ICadesException>;
  OCSPResponses: Promise<{} | ICadesException>;
  Options: Promise<number | ICadesException>;
  SignatureStatus: Promise<ICryptoProSignatureStatus>;
  SignatureTimeStampTime: Promise<{} | ICadesException>;
  SigningTime: Promise<{} | ICadesException>;
  TSAAddress: Promise<string | ICadesException>;
  UnauthenticatedAttributes: Promise<{} | ICadesException>;

  propset_Certificate: (certificate: ICryptoProCertificate) => Promise<void>;
  propset_CheckCertificate: (check: boolean) => Promise<void>;
  propset_TSAAddress: (url: string) => Promise<void>;
  propset_Options: (chainIndex: number) => Promise<void>
}

declare interface ICryptoProSigners {
  Item(index: number): Promise<ICryptoProSigner>;
  objid: number;
  propset_Count(i: number): void;
  Count: Promise<number>;
}

declare interface ICryptoProHashedData {
  Hash(content: string): Promise<void>;
  SetHashValue(value: any): void;
  objid: number;
  propset_Algorithm(algorithm: number): Promise<void>;
  propset_DataEncoding(type: number): Promise<void>;
  propset_Key(): Promise<void>;
  propset_Value(): Promise<void>;
  Algorithm: Promise<any>;
  DataEncoding: Promise<any>;
  Key: Promise<any>;
  Value: Promise<any>;
}

declare interface ICryptoProSignedData {
  objid: number;
  Signers: Promise<ICryptoProSigners>;

  propset_ContentEncoding: (convertType: number) => Promise<void>;
  propset_Content: (content: string | ArrayBuffer) => Promise<void>;

  AdditionalStore: (store: ICryptoProStore) => Promise<void>;
  CoSign: (signer?: ICryptoProSigner, encodingType?: number) => Promise<string>;
  Sign: (signer?: ICryptoProSigner, detached?: boolean, encodingType?: number) => Promise<string>;
  Verify: (signedMessage: string, detached?: boolean, verifyFlag?: number) => Promise<string>;
  Display: (parent: number, title: string) => Promise<void>;
  CoSignCades: (signer: ICryptoProSigner, cadesType: number, encodingType: number, signedMessage: string) => Promise<number>;
  EnhanceCades: (signer: ICryptoProSigner, TSAAddress: string, encodingType: number, signedMessage: string) => Promise<number>;
  SignCades: (signer: ICryptoProSigner, cadesType: number, detached: boolean, encodingType?: number, signedMessage?: string) => Promise<string>;
  SignHash(oHashedData: ICryptoProHashedData, signer: cadesplugin.ICryptoProSigner, cadesType: number): PromiseLike<string>;
  VerifyCades: (signedMessage: string, cadesType: number, detached: boolean) => Promise<string>;
  VerifyHash(oHashedData: ICryptoProHashedData, sign: string, cadesType: number): Promise<string>;
}

declare interface ICryptoProRawSignature {
  Signers: Promise<ICryptoProSigners>;
  VerifyHash(oHashedData: ICryptoProHashedData, ceritficate: ICryptoProCertificate, rawSignature: string): Promise<string>;
}

declare interface ICryptoProPrivateKey {
  objid: number;
  propset_Algorithm(value: number): Promise<void>;
  propset_EncodedKey(value: object): Promise<void>;
  propset_EncodedParameters(value: object): Promise<void>;
  propset_Length(value: number):Promise<void>;
  Algorithm: Promise<ICryptoProAlgorithm>;
  EncodedKey: Promise<any>;
  EncodedParameters: Promise<any>;
  Length: Promise<any>;
}

declare interface ICryptoProAlgorithm {
  objid;
  propset_FriendlyName();
  propset_Name();
  propset_Value();
  FriendlyName: Promise<string>;
  Name: Promise<string>;
  Value: Promise<string>;
}

declare interface ICryptoProCertificateCheckResults {
  objid: number;
  propset_ErrorStatuses();
  propset_Result();
  propset_ValidationCertificates();
  ErrorStatuses: Promise<any>;
  Result: Promise<any>
  ValidationCertificates: Promise<any>;
}

declare interface ICryptoProSignatureStatus{
  objid: number;
  IsValid: Promise<boolean>;
}

declare interface ICryptoProCertificate {
  AdditionalStore: (store: ICryptoProStore) => Promise<void>;
  Export: (encodingType: number) => Promise<string>;
  BasicConstraints: () => Promise<{}>;
  ExtendedKeyUsage: () => Promise<{}>;
  GetInfo: (infoType: number) => Promise<unknown>;
  HasPrivateKey: () => Promise<boolean>;
  Import: (encodedCertificate: string) => Promise<void>;
  IsValid: () => Promise<ICryptoProCertificateCheckResults>;
  KeyUsage: () => Promise<{}>;
  PublicKey: () => Promise<ICryptoProPrivateKey>;
  Extensions: () => Promise<{}>;
  FindPrivateKey: (certificateOfPublicKey: any) => Promise<number>;

  objid: number;

  IssuerName: Promise<string>;
  PrivateKey: Promise<{}>;
  SerialNumber: Promise<string>;
  SubjectName: Promise<string>;
  Thumbprint: Promise<string>;
  ValidFromDate: Promise<string>;
  ValidToDate: Promise<string>;
  Version: Promise<number>;
}

declare interface ICryptoProCertificates {
  Find: (type: CAPICOM_CERTIFICATE_FIND_TYPE, subjectName: number, certificateName: string) => Promise<ICryptoProCertificate | undefined>;
  // index starts with 1
  Item: (index: number) => Promise<ICryptoProCertificate>;
  objid: number;
  Count: Promise<number>;
}

declare interface ICryptoProStore {
  Certificates: Promise<ICryptoProCertificates>;
  Location:	Promise<number>;
  Name: Promise<string>;
  objid: number;

  Add: () => Promise<unknown>;
  Remove: () => Promise<unknown>;
  AddCRL: () => Promise<unknown>;
  Open: (containerStore: number, certificateStore: string, openMaximumAllowed: number) => Promise<unknown>;
  Close: () => Promise<unknown>;
  Export: () => Promise<unknown>;

  addEventListener: (event: Event, listener: (e: Event) => {}, capture: boolean) => {};
  removeEventListener: (event: Event, listener: (e: Event) => {}, capture: boolean) => {};
}