import { signatureAlgorithms } from "../supportedAlgorithms";

export class CertificateValidator {
  
  async isValidCertificate(certificate: ICryptoProCertificate): Promise<boolean> {
    const hasPrivateKey = await certificate.HasPrivateKey();
    if (!hasPrivateKey)
      return false;

    const publicKeyOid = await certificate.PublicKey();
    const algorithm = await publicKeyOid.Algorithm;
    const value = await algorithm.Value;
    if (!signatureAlgorithms.has(value))
      return false;

    const validToDate = await certificate.ValidToDate;
    return Date.parse(validToDate) >= Date.now();
  }
}