﻿using Org.BouncyCastle.Asn1.Pkcs;
using Org.BouncyCastle.Asn1;
using Org.BouncyCastle.Tsp;
using Org.BouncyCastle.Cms;
using Org.BouncyCastle.X509;

namespace PdfStamper.Certificates;

internal class Asn1Helper
{
    public static TimeStampToken? GetTimestampToken(SignerInformation signerInfo)
    {
        if (signerInfo.UnsignedAttributes == null)
            return null;


        var tsAttr = signerInfo.UnsignedAttributes[PkcsObjectIdentifiers.IdAASignatureTimeStampToken];
        if (tsAttr == null)
            return null;

        var derEncodable = tsAttr.AttrValues.FirstOrDefault();
        if (derEncodable == null)
            return null;

        var encoded = derEncodable.ToAsn1Object().GetEncoded();
        var tst = new TimeStampToken(new CmsSignedData(encoded));
        return tst;
    }

    public static X509Certificate? GetTimeStampCertificate(TimeStampToken token)
    {
        var asnCertificateSet = token.UnsignedAttributes.GetAll(PkcsObjectIdentifiers.IdAAEtsCertValues);
        if (asnCertificateSet == null)
            return null;

        if (asnCertificateSet.FirstOrDefault() is not Org.BouncyCastle.Asn1.Cms.Attribute attributeCerts)
            return null;

        if (attributeCerts.AttrValues.FirstOrDefault() is not Asn1Sequence asnObjCerts)
            return null;

        var firstCertOfChain = asnObjCerts[0];
        if (firstCertOfChain == null)
            return null;

        var encoded = firstCertOfChain.GetEncoded();
        var cert = new X509Certificate(encoded);
        return cert;
    }
}
