﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using PdfSharp.Drawing;
using PdfSharp.Pdf.Advanced;
using System.Reflection;

namespace PdfStamper;
internal static class XFormExtensions
{
    public static PdfFormXObject? GetPdfFormXObject(this XForm form)
    {
        var type = form.GetType();
        var internalField = type.GetField("_pdfForm", BindingFlags.Instance | BindingFlags.NonPublic);
        if (internalField == null)
            return null;

        var internalValue = internalField.GetValue(form) as PdfFormXObject;
        return internalValue;
    }
}
